' Ten kod pochodzi z ksiki "ASP.NET 2.0. Gotowe rozwizania" autorstwa
' Imara Spaanjaarsa, Paula Wiltona and Shawna Livermore, wydanej przez Wrox.
' Polska edycja: Wydawnictwo Helion. 
' Copyright 2006 by Wiley Publishing Inc.
' Informacja o tej ksice jest dostpna na stronie www.wrox.com.  
' Odwied p2p.wrox.com aby podyskutowa o tym kodzie na forach Wrox.

Partial Class BlogEntriesFilter
  Inherits System.Web.UI.UserControl

  Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load

    If Not Page.IsPostBack Then
      Dim startDate As DateTime = DateTime.MinValue
      Dim endDate As DateTime = DateTime.MinValue
      If Request.QueryString.Get("startDate") IsNot Nothing Then
        startDate = Convert.ToDateTime(Request.QueryString.Get("startDate"))
      End If
      If Request.QueryString.Get("endDate") IsNot Nothing Then
        endDate = Convert.ToDateTime(Request.QueryString.Get("endDate"))
      Else
        endDate = startDate
      End If
      calBlogEntries.VisibleDate = startDate

      While endDate >= startDate
        calBlogEntries.SelectedDates.Add(startDate)
        startDate = startDate.AddDays(1)
      End While

      repCategories.DataSource = BlogManager.GetCategories()
      repCategories.DataBind()
    End If
  End Sub

  Protected Sub calBlogEntries_SelectionChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles calBlogEntries.SelectionChanged
    If calBlogEntries.SelectedDates.Count > 0 Then
      Dim startDate As DateTime = calBlogEntries.SelectedDates(0)
      Dim endDate As DateTime = calBlogEntries.SelectedDates(calBlogEntries.SelectedDates.Count - 1)

      Dim queryString As String = String.Empty

      If Request.QueryString.Count > 0 Then
        queryString = Server.UrlDecode(Request.QueryString.ToString())
        If Request.QueryString.Get("startDate") IsNot Nothing Then
          queryString = queryString.Replace("startDate=" & Request.QueryString.Get("startDate"), "startDate=" & startDate.ToShortDateString())
        Else
          queryString &= "&startDate=" & startDate.ToShortDateString()
        End If
        If Request.QueryString.Get("endDate") IsNot Nothing Then
          queryString = queryString.Replace("endDate=" & Request.QueryString.Get("endDate"), "endDate=" & endDate.ToShortDateString())
        Else
          queryString &= "&endDate=" & endDate.ToShortDateString()
        End If
      Else
        queryString = String.Format("startDate={0}&endDate={1}", startDate.ToShortDateString(), endDate.ToShortDateString())
      End If

      Response.Redirect(Request.CurrentExecutionFilePath & "?" & queryString)
    End If
  End Sub

  Public Function GetNavigateUrl(ByVal categoryId As Object) As String
    Dim myCategoryId As Integer = Convert.ToInt32(categoryId)
    Dim queryString As String = Server.UrlDecode(Request.QueryString.ToString())

    If Request.QueryString.Count > 0 Then
      ' Istnieje ju QueryString
      If Request.QueryString.Get("categoryId") IsNot Nothing Then
        queryString = queryString.Replace("categoryId=" & Request.QueryString.Get("categoryId"), "categoryId=" & categoryId.ToString())
      Else
        queryString &= "&categoryId=" & categoryId.ToString()
      End If
      If Request.QueryString.Get("startDate") IsNot Nothing Then
        queryString = queryString.Replace("&startDate=" & Request.QueryString.Get("startDate"), "")
        queryString = queryString.Replace("startDate=" & Request.QueryString.Get("startDate"), "")
      End If
      If Request.QueryString.Get("endDate") IsNot Nothing Then
        queryString = queryString.Replace("&endDate=" & Request.QueryString.Get("endDate"), "")
        queryString = queryString.Replace("endDate=" & Request.QueryString.Get("endDate"), "")
      End If
    Else
      queryString = String.Format("categoryId={0}", categoryId.ToString())
    End If
    Return Request.CurrentExecutionFilePath & "?" & queryString

  End Function

End Class
